/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.client;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.class_1011;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_746;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.data.material.AbstractMaterialSpriteProvider;
import slimeknights.tconstruct.library.client.data.material.AbstractPartSpriteProvider;
import slimeknights.tconstruct.library.client.data.material.MaterialPartTextureGenerator;
import slimeknights.tconstruct.library.client.data.util.ResourceManagerSpriteReader;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfoJson;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfoLoader;
import slimeknights.tconstruct.library.client.model.DynamicTextureLoader;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.shared.network.GeneratePartTexturesPacket;

public class ClientGeneratePartTexturesCommand {
    private static final Logger log = LogManager.getLogger(ClientGeneratePartTexturesCommand.class);
    private static final String SUCCESS_KEY = TConstruct.makeTranslationKey("command", "generate_part_textures.finish");
    private static final class_2561 NO_PARTS = TConstruct.makeTranslation("command", "generate_part_textures.no_parts");
    private static final class_2561 NO_MATERIALS = TConstruct.makeTranslation("command", "generate_part_textures.no_materials");
    private static final String PACK_NAME = "TinkersConstructGeneratedPartTextures";
    private static final String GENERATOR_PART_TEXTURES = "tinkering/generator_part_textures.json";

    protected static class_2561 getOutputComponent(File file) {
        return class_2561.method_43470((String)file.getAbsolutePath()).method_27694(style -> style.method_30938(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11746, file.getAbsolutePath())));
    }

    public static void generateTextures(GeneratePartTexturesPacket.Operation operation, String modId, String materialPath) {
        long time = System.nanoTime();
        class_3300 manager = class_310.method_1551().method_1478();
        MaterialPartTextureGenerator.runCallbacks(null, manager);
        class_746 player = class_310.method_1551().field_1724;
        List<AbstractPartSpriteProvider.PartSpriteInfo> partSprites = ClientGeneratePartTexturesCommand.loadPartSprites(manager);
        if (partSprites.isEmpty()) {
            if (player != null) {
                player.method_7353(NO_PARTS, false);
            }
            return;
        }
        Predicate<MaterialVariantId> validMaterialId = loc -> !(!modId.isEmpty() && !modId.equals(loc.getId().method_12836()) || !materialPath.isEmpty() && !materialPath.equals(loc.getId().method_12832()));
        List<AbstractMaterialSpriteProvider.MaterialSpriteInfo> materialSprites = ClientGeneratePartTexturesCommand.loadMaterialRenderInfoGenerators(manager, validMaterialId);
        if (materialSprites.isEmpty()) {
            if (player != null) {
                player.method_7353(NO_MATERIALS, false);
            }
            return;
        }
        Path path = class_310.method_1551().method_1479().resolve(PACK_NAME);
        BiConsumer<class_2960, class_1011> saver = (outputPath, image) -> ClientGeneratePartTexturesCommand.saveImage(path, outputPath, image);
        ClientGeneratePartTexturesCommand.savePackMcmeta(path);
        ResourceManagerSpriteReader spriteReader = new ResourceManagerSpriteReader(manager, "textures");
        MutableInt generated = new MutableInt(0);
        Predicate<class_2960> shouldGenerate = operation == GeneratePartTexturesPacket.Operation.ALL ? exists -> {
            generated.add(1);
            return true;
        } : loc -> {
            if (!spriteReader.exists((class_2960)loc)) {
                generated.add(1);
                return true;
            }
            return false;
        };
        for (AbstractMaterialSpriteProvider.MaterialSpriteInfo material : materialSprites) {
            for (AbstractPartSpriteProvider.PartSpriteInfo part : partSprites) {
                if (!material.supportStatType(part.getStatType())) continue;
                MaterialPartTextureGenerator.generateSprite(spriteReader, material, part, shouldGenerate, saver);
            }
        }
        spriteReader.closeAll();
        DynamicTextureLoader.clearCache();
        long deltaTime = System.nanoTime() - time;
        int count = generated.getValue();
        MaterialPartTextureGenerator.runCallbacks(null, null);
        log.info("Finished generating {} textures in {} ms", (Object)count, (Object)Float.valueOf((float)deltaTime / 1000000.0f));
        if (class_310.method_1551().field_1724 != null) {
            class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43469((String)SUCCESS_KEY, (Object[])new Object[]{count, Float.valueOf((float)(deltaTime / 1000000L) / 1000.0f), ClientGeneratePartTexturesCommand.getOutputComponent(path.toFile())}), false);
        }
    }

    private static void savePackMcmeta(Path folder) {
        Path path = folder.resolve("pack.mcmeta");
        JsonObject meta = new JsonObject();
        JsonObject pack = new JsonObject();
        pack.addProperty("description", "Generated Resources from the Tinkers' Construct Part Texture Generator");
        pack.addProperty("pack_format", (Number)8);
        meta.add("pack", (JsonElement)pack);
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            String json = MaterialRenderInfoLoader.GSON.toJson((JsonElement)meta);
            try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                bufferedwriter.write(json);
            }
        }
        catch (IOException e) {
            log.error("Couldn't create pack.mcmeta for part textures", (Throwable)e);
        }
    }

    private static void saveImage(Path folder, class_2960 location, class_1011 image) {
        Path path = folder.resolve(Paths.get(class_3264.field_14188.method_14413(), location.method_12836(), "textures", location.method_12832() + ".png"));
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            image.method_4314(path);
        }
        catch (IOException e) {
            log.error("Couldn't create image for {}", (Object)location, (Object)e);
        }
    }

    private static List<AbstractPartSpriteProvider.PartSpriteInfo> loadPartSprites(class_3300 manager) {
        ImmutableList.Builder builder = ImmutableList.builder();
        block7: for (String namespace : manager.method_14487()) {
            class_2960 location = new class_2960(namespace, GENERATOR_PART_TEXTURES);
            List resources = manager.method_14489(location);
            if (resources.isEmpty()) continue;
            for (int r = resources.size() - 1; r >= 0; --r) {
                class_3298 resource = (class_3298)resources.get(r);
                try {
                    BufferedReader reader = resource.method_43039();
                    try {
                        JsonObject object = class_3518.method_15255((Reader)reader);
                        List<AbstractPartSpriteProvider.PartSpriteInfo> parts = JsonHelper.parseList(object, "parts", (element, name) -> {
                            JsonObject part = class_3518.method_15295((JsonElement)element, (String)name);
                            class_2960 path = JsonHelper.getResourceLocation(part, "path");
                            MaterialStatsId statId = new MaterialStatsId(JsonHelper.getResourceLocation(part, "statType"));
                            return new AbstractPartSpriteProvider.PartSpriteInfo(path, statId);
                        });
                        builder.addAll(parts);
                        if (!class_3518.method_15258((JsonObject)object, (String)"replace", (boolean)false)) continue;
                        continue block7;
                    }
                    finally {
                        if (reader == null) continue block7;
                        reader.close();
                        continue block7;
                    }
                }
                catch (IOException ex) {
                    log.error("Failed to load modifier models from {} for pack {}", (Object)location, (Object)resource.method_14480(), (Object)ex);
                }
            }
        }
        return builder.build();
    }

    private static List<AbstractMaterialSpriteProvider.MaterialSpriteInfo> loadMaterialRenderInfoGenerators(class_3300 manager, Predicate<MaterialVariantId> validMaterialId) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int trim = "tinkering/materials".length() + 1;
        for (Map.Entry entry : manager.method_14488("tinkering/materials", loc -> loc.method_12832().endsWith(".json")).entrySet()) {
            MaterialVariantId id;
            class_2960 location = (class_2960)entry.getKey();
            String path = location.method_12832();
            String localPath = path.substring(trim, path.length() - 5);
            String variant = "";
            int slashIndex = localPath.lastIndexOf(47);
            if (slashIndex >= 0) {
                variant = localPath.substring(slashIndex + 1);
                localPath = localPath.substring(0, slashIndex);
            }
            if (!validMaterialId.test(id = MaterialVariantId.create(location.method_12836(), localPath, variant))) continue;
            try {
                BufferedReader reader = ((class_3298)entry.getValue()).method_43039();
                try {
                    MaterialRenderInfoJson json = (MaterialRenderInfoJson)MaterialRenderInfoLoader.GSON.fromJson((Reader)reader, MaterialRenderInfoJson.class);
                    MaterialRenderInfoJson.MaterialGeneratorJson generator = json.getGenerator();
                    if (generator == null) continue;
                    builder.add((Object)new AbstractMaterialSpriteProvider.MaterialSpriteInfo(Objects.requireNonNullElse(json.getTexture(), id.getLocation('_')), Objects.requireNonNullElse(json.getFallbacks(), new String[0]), generator));
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (JsonSyntaxException e) {
                log.error("Failed to read tool part texture generator info for {}", (Object)id, (Object)e);
            }
            catch (Exception exception) {}
        }
        return builder.build();
    }
}

